//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Messaging;

namespace FrameworkLibraries
{
	public class MessageQueueSend 
	{
		static void Main(string [] args)
		{
			string message = "Witaj!!!";
			if(args.Length > 0)
				message = args[0];
			// Utworzenie nowego egzemplarza klasy.
			MessageQueueSend myNewQueue = new MessageQueueSend();
			// Wysanie wiadomoci do kolejki.
			myNewQueue.SendMessage(message);
			return;
		}
		//**************************************************
		// Wysyanie wiadomoci do kolejki.
		//**************************************************
  		public void SendMessage(string message)
		{
			string queueName = ".\\myQueue";
			if(MessageQueue.Exists(queueName))
			{
				// Poczenie z kolejk na komputerze lokalnym.
				MessageQueue myQueue = new MessageQueue(queueName);
				// Ustawienie formatera w celu wskazanie, e wiadomo zawiera polecenie.
				myQueue.Formatter = new XmlMessageFormatter(new string[]{"System.String"});
				// Wysanie wiadomoci do kolejki.
				if (myQueue.Transactional == true)
				{
					Console.WriteLine("Wysyanie wiadomoci tranzakcyjnej");
					myQueue.Send(message, new MessageQueueTransaction());
				}
				else
				{
					Console.WriteLine("Wysyania wiadomoci");
					myQueue.Send(message);
				}
			}
			else
			{
				Console.WriteLine("{0} nie istnieje.", queueName);
				MessageQueue [] mqa = MessageQueue.GetPublicQueues();
				foreach(MessageQueue m in mqa)
				{
					Console.WriteLine("Publiczna: {0}", m.QueueName);
				}
				mqa = MessageQueue.GetPrivateQueuesByMachine(".");
				foreach(MessageQueue m in mqa)
				{
					Console.WriteLine("Prywatna: {0}", m.QueueName);
				}
			}
			return;
		}
	}
}